// Header file for winebooker.cpp
//
// copyright 2003 Neil Barnes 
//
// nailed_barnacle@hotmail.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the license, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef __EMU__
#define __EMU__

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <time.h>
#include "resource.h"


// seeing as there are wheel mice out there, it seems a shame to ignore them
// and as msvc 4.2 doesn't know about them, we bodge the message

#define		WM_WHEELMOUSE		522

PSTR 				szProgName = "Fiat Punto 75 Mk1";    // application name
HINSTANCE		ghInstance;
HWND				hWnd;
PAINTSTRUCT ps;
HDC					hDC;

HWND				hEdit;



int PASCAL WinMain (HINSTANCE, HINSTANCE, LPSTR, int);
LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);

void SetComms (int baud);
unsigned char	GetPuntoEngineStatus (unsigned char ch, unsigned char noshow);

// some colour definitions

#define RED RGB(255,0,0)
#define GREEN RGB(0,255,0)
#define AMBER RGB(255,255,0)
#define MURPLE RGB(255,128,255)

static HBRUSH	hbRed;
static HBRUSH hbGreen;
static HBRUSH hbAmber;
static HBRUSH hbMurple;

#define TICKTOCK 1

enum _enginetype {NOTHING, PUNTO}; 

union	_16bit {
	unsigned short big;
	unsigned char little[2];
};

struct _engine {
	_16bit revs;
	_16bit injperiod;
	unsigned char advance;
	unsigned char vacuum;
	unsigned char airtemp;
	unsigned char watertemp;
	unsigned char throttle;
	unsigned char battery;
	unsigned char injtiming;
	unsigned char vae;
	unsigned char errcoinp;
	unsigned char errcoout;
	unsigned char errcofun;
	unsigned char secoinp;
	unsigned char secoout;
	unsigned char secofun;
	unsigned char unieep1;
	unsigned char unieep2;
	unsigned char unieep3;
};

struct _massage {
	float revs;
	float injperiod;
	float advance;
	float vacuum;
	float airtemp;
	float watertemp;
	float throttle;
	float battery;
	float vae;
	unsigned char errcoinp;
	unsigned char errcoout;
	unsigned char errcofun;
	unsigned char secoinp;
	unsigned char secoout;
	unsigned char secofun;
};


	

// a class to handle drawing the analogue displays in a pretty way

class Gauge {

public:

  Gauge (char * _title,			// what's the gauge called?
				char * _units,			// what units to display?
				int _height,				// how high is the display?
				int _x, 
				int _y,							// position of top left corner
				int _low,						// minimum display value
				int _high,					// maximum display value
				int _majortick,			// interval between labeled index marks
				int _minortick,			// interval between unlabeled index marks
				int _hieek,					// high danger level
				int _hiwarn,				// high warning level
				int _lowarn,				// low warning level (i.e. warn if below this value
				int _loeek,					// low danger level
				int places);				// number of decimal places in the dsplayed value

	void Show (HDC hDC, float value);
	void Update (HDC hDC, float value);
	int	Percentage (void);

	void Rescale(int _low,						// minimum display value
							int _high,					// maximum display value
							int _majortick,			// interval between labeled index marks
							int _minortick,			// interval between unlabeled index marks
							int _hieek,					// high danger level
							int _hiwarn,				// high warning level
							int _lowarn,				// low warning level (i.e. warn if below this value
							int _loeek);				// low danger level


private:

	char title[16];
	char units[16];
	float	value;				// the value we're currently displaying
	int height;				// height of the display, inc the title and value print
	int x;
	int y;						// location of the display
	int low;					// the lowest value on the scale
	int high;					// the highest value on the scale
	int majortick;		// the larger index mark spacing
	int minortick;		// the lesser index mark spacing (no values)
	int hieek;				// the value above which the value is considered dangerously high
	int hiwarn;				// the value above which a warning is necessary
	int lowarn;				// the value below which a warning is necessary
	int loeek;				// the value below which a warning is necessary
	int places;				// the number of decimal places to display


};

#endif
